#include <WinAPIEx.au3>

#RequireAdmin

If IsAdmin() Then
	$sText = InputBox(' ', '         Test.exe')
	If (($sText <> '') And (Not @error)) Then
		__pe_AddDataToOverlay(@ScriptDir & '\Test.exe', $sText)
		If @error Then
			MsgBox(0, '', '')
		EndIf
	EndIf
EndIf

Func __pe_AddDataToOverlay($sFile, $sText)

	Local $iResult, $iBytes

	$tBuffer = DllStructCreate('byte[' & StringLen($sText) & ']')
	DllStructSetData($tBuffer, 1, $sText)

	$hFile = _WinAPI_CreateFile($sFile, 2, 4)
	If ((Not $hFile) And @error) Then
		Return SetError(1, 0, 0)
	EndIf
	_WinAPI_SetFilePointer($hFile, _WinAPI_GetFileSizeEx($hFile))
	If _WinAPI_WriteFile($hFile, DllStructGetPtr($tBuffer), DllStructGetSize($tBuffer), $iBytes) Then
		$iResult = 1
	EndIf

	_WinAPI_CloseHandle($hFile)

	Return $iResult
EndFunc